% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program DriftingYellowBar.m

function DriftingYellowBar(pixelsPerFrame)
 
%% Display Setup Module
% Define display parameters
whichScreen = max(Screen('screens'));
p.ScreenGamma = 2;	% from monitor calibration
p.ScreenBackground = 0;

% Open display window and hide the mouse cursor

if exist('onCleanup', 'class'), oC_Obj = onCleanup(@()sca); end % close any pre-existing PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General', 'FloatingPoint32BitIfPossible');   % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General', 'NormalizedHighresColorRange');
PsychImaging('AddTask', 'FinalFormatting', 'DisplayColorCorrection', 'SimpleGamma');
[windowPtr p.ScreenRect] = PsychImaging('OpenWindow', whichScreen, p.ScreenBackground);
PsychColorCorrection('SetEncodingGamma', windowPtr, 1 / p.ScreenGamma);
HideCursor;

%% Experimental Module

% Specify the stimulus
p.barWidth = 4; % in pixels
sz = 128; % bar length in pixels
if nargin < 1, pixelsPerFrame = p.barWidth; end 
        % shift pixels per frame
 
% Compute stimulus parameters
[xc yc] = RectCenter(p.ScreenRect);
xy = [[1 1 1 1] * xc; [[-32 -3]-sz/2 -sz/2  sz/2] + yc];
 
% Show the moving bar
while 1
    Screen('DrawLines', windowPtr, xy, p.barWidth, ...
           [1 1 0]);
    Screen('Flip', windowPtr);
    if ReadKey('esc'), break; end 
    xy(1, 3 : 4) = xy(1, 3 : 4) + pixelsPerFrame;
    if xy(1, 3) > xc + sz / 2, xy(1, 3 : 4) =  xy(1, 3 : 4) - sz; end
end 

  
%% System Reinstatement Module
Screen('CloseAll'); % close window and textures

